<?php

namespace App\Http\Controllers;

use App\Mail\GetQuoteRequest;
use App\Mail\GetQuoteSent;
use App\Mail\RequestQuote;
use App\Mail\RequestSent;
use Illuminate\Http\Request;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\TwitterCard;
use Illuminate\Support\Facades\Mail;

class HomeController extends Controller
{
    public function index()
    {
        SEOMeta::setTitle('Adamant Logistics Solution');
        SEOMeta::setDescription('Adamant Logistics offer warehousing services, customs clearance, refrigerated trucks services, supply chain consultancy, sea freight and air freight.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);

        OpenGraph::setDescription('Adamant Logistics offer warehousing services, customs clearance, refrigerated trucks services, supply chain consultancy, sea freight and air freight.');
        OpenGraph::setTitle('Adamant Logistics Solution');
        OpenGraph::setUrl('https://adamant.co.ke/');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Homepage');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/');

        return view('welcome');
    }

    public function shopship()
    {
        SEOMeta::setTitle('Products shop and ship');
        SEOMeta::setDescription('Products shop and ship logistics with Adamant Logistics shop and ship products in Kenya and also shop and ship products logistics to the rest of the world.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Products shop and ship logistics with Adamant Logistics shop and ship products in Kenya and also shop and ship products logistics to the rest of the world.');
        OpenGraph::setTitle('Products shop and ship');
        OpenGraph::setUrl('https://adamant.co.ke/shop-and-ship');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Products shop and ship');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/shop-and-ship');

        return view('pages.shopship');
    }

    public function services()
    {
        SEOMeta::setTitle('Our Services');
        SEOMeta::setDescription('Logistics services offered by Adamant Logistics solution to Kenya and rest of East Africa involving transport and logistics with Adamant Logistics services.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Logistics services offered by Adamant Logistics solution to Kenya and rest of East Africa involving transport and logistics with Adamant Logistics services.');
        OpenGraph::setTitle('Our Services');
        OpenGraph::setUrl('https://adamant.co.ke/services');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('services');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/services');

        return view('pages.services');
    }

    public function contact()
    {
        SEOMeta::setTitle('Contact us');
        SEOMeta::setDescription('Contact info for Adamant Logistics include E-mail info@adamant.co.ke and phone +254 728 991 344 and we are located at Savannah Business Park, Nairobi, Kenya.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Contact info for Adamant Logistics include E-mail info@adamant.co.ke and phone +254 728 991 344 and we are located at Savannah Business Park, Nairobi, Kenya.');
        OpenGraph::setTitle('Contact us');
        OpenGraph::setUrl('https://adamant.co.ke/contact');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Contact us');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/contact');

        return view('pages.contact');
    }

    public function about()
    {
        SEOMeta::setTitle('About us');
        SEOMeta::setDescription('Adamant Logistics is an integrated end to end logistics service provider. We offer logistics solutions and services to clients in Kenya and Global.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Adamant Logistics is an integrated end to end logistics service provider. We offer logistics solutions and services to clients in Kenya and Global.');
        OpenGraph::setTitle('About us');
        OpenGraph::setUrl('https://adamant.co.ke/about');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('About us');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/about');

        return view('pages.about');
    }

    public function terms()
    {
        SEOMeta::setTitle('Terms and Conditions');
        SEOMeta::setDescription('Terms and conditions overview of applicable terms and conditions in Adamant Logistics to the rest of the world.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Terms and conditions overview of applicable terms and conditions in Adamant Logistics to the rest of the world.');
        OpenGraph::setTitle('Terms and Conditions');
        OpenGraph::setUrl('https://adamant.co.ke/terms');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Terms and Conditions');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/terms');

        return view('pages.terms');
    }

    public function press()
    {
        SEOMeta::setTitle('Press informations');
        SEOMeta::setDescription('Press information on Adamant Logistics solution and services on day to day basis on press information value help by Adamant Logistics solution.');
        SEOMeta::addKeyword([
            'Adamant Logistics service', 'supply chain consultancy', 'air freight',
            'sea freight', 'warehousing services', 'custom brokerage', 'refrigerated trucks', 'all perishable products transport', 'transport and distribution'
        ]);
        OpenGraph::setDescription('Press information on Adamant Logistics solution and services on day to day basis on press information value help by Adamant Logistics solution.');
        OpenGraph::setTitle('Press');
        OpenGraph::setUrl('https://adamant.co.ke/press');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Press informations');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/press');

        return view('pages.press');
    }

    public function contactForm(Request $request)
    {
        $content = $this->validate($request, [
            'username' => 'required|string|max:255',
            'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|min:10',
            'email' => 'required|string|email|max:255',
            'message' => 'required|string'
        ]);

        Mail::to('gilbert@adamant.co.ke')
            ->cc('agnes@adamant.co.ke')
            ->queue(new RequestQuote($content));

        Mail::to($content['email'])->queue(new RequestSent($content));

        request()->session()->flash('flash.banner', "Email sent successfully!");
        request()->session()->flash('flash.bannerStyle', 'success');

        return redirect()->back();
    }

    public function quote()
    {
        SEOMeta::setTitle('Get a Quote');
        SEOMeta::setDescription('We plan, implement and operate complex supply chain solutions on a national, regional and global scale on behalf of small, medium to large corporate firms.');
        SEOMeta::addKeyword(['Get a Quote']);
        OpenGraph::setDescription('We plan, implement and operate complex supply chain solutions on a national, regional and global scale on behalf of small, medium to large corporate firms.');
        OpenGraph::setTitle('Get a Quote');
        OpenGraph::setUrl('https://adamant.co.ke/get-a-quote');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);
        TwitterCard::setTitle('Get a Quote');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/get-a-quote');

        return view('pages.quote');
    }

    public function quoteForm(Request $request)
    {
        $content = $this->validate($request, [
            'company-name' => 'required|string|max:255',
            'contact-name' => 'required|string|max:255',
            'email-address' => 'required|string|email|max:255',
            'phone-number' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|min:10',
            'service' => 'required|string|max:255',
            'description-of-cargo' => 'nullable|string|max:255',
            'hs-code' => 'nullable|string|max:255',
            'cargo-weight-dimensions' => 'nullable|string|max:255',
            'number-of-packages' => 'nullable|numeric|max:10|min:1',
            'cargo-value' => 'nullable|string|max:255',
            'collection-address' => 'nullable|string|max:255',
            'delivery-address' => 'nullable|string|max:255',
            'cargo-state' => 'nullable|string|max:255',
            'additional-info' => 'nullable|string',
        ]);

        Mail::to('gilbert@adamant.co.ke')
            ->cc('agnes@adamant.co.ke')
            ->queue(new GetQuoteRequest($content));

        Mail::to($content['email-address'])->queue(new GetQuoteSent($content));

        request()->session()->flash('flash.banner', "Email sent successfully!");
        request()->session()->flash('flash.bannerStyle', 'success');

        return redirect()->back();
    }
}
