<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\TwitterCard;

class ServiceController extends Controller
{
    // services
    public function supply()
    {
        SEOMeta::setTitle('Supply Chain Consultancy Kenya');
        SEOMeta::setDescription('Supply Chain consultant Kenya, Adamant Logistics solution, offer the best supply chain consultancy to add growth in supply chain consultancy in Kenya.');
        SEOMeta::addKeyword([
            'supply chain consultancy Kenya', 'Value Chain Consultants Kenya', 'Procurement and Supply Chain advisory services Kenya',
            'Supply Chain & Procurement Jobs in Kenya', 'Functional Supply Chain Consultant Kenya', 'Supply chain management consultant jobs', 'Procurement Kenya', 'Store keeping kenya', 'Supply Chain Kenya', 'Supply Chain Management'
        ]);
        OpenGraph::setDescription('Supply Chain consultant Kenya, Adamant Logistics solution, offer the best supply chain consultancy to add growth in supply chain consultancy in Kenya.');
        OpenGraph::setTitle('Supply Chain Consultancy Kenya');
        OpenGraph::setUrl('https://adamant.co.ke/supply-chain-consultancy');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Supply Chain Consultancy Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/supply-chain-consultancy');

        return view('pages.supply');
    }

    public function air()
    {
        SEOMeta::setTitle('Air Freight Logistics Kenya');
        SEOMeta::setDescription('Air Freight in Kenya Adamant Logistics offer the best air freight in Kenya for perishable goods to global air freight transportation and distribution.');
        SEOMeta::addKeyword([
            'Air Cargo Kenya', 'Air Freight & Shipping to Kenya', 'KQ Cargo Break bulk Kenya',
            'Air Freight Companies in Kenya', 'Air Freight to Nairobi, Kenya', 'Air Cargo Logistics Limited',
            'Freight Forwarders', 'freight to Kenya', 'air freight', 'air freight logistics'
        ]);
        OpenGraph::setDescription('Air Freight in Kenya Adamant Logistics offer the best air freight in Kenya for perishable goods to global air freight transportation and distribution.');
        OpenGraph::setTitle('Air Freight');
        OpenGraph::setUrl('https://adamant.co.ke/air-freight');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);



        TwitterCard::setTitle('Air Freight Logistics Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/air-freight');


        return view('pages.air');
    }

    public function sea()
    {
        SEOMeta::setTitle('Sea Freight Logistics Kenya');
        SEOMeta::setDescription('Sea Freight Logistics Kenya, Adamant Logistics offer the best sea freight logistics in Kenya and global sea freights logistics and ocean freights Kenya.');
        SEOMeta::addKeyword([
            'Air Freight Services', 'Sea freight companies in Kenya', 'Sea Freight Service To Kenya',
            'Global Express Line Ltd', 'Sea and Air Freight Mombasa', 'Best Freight Forwarding Services & Logistics Companies Kenya', 'Freight Forwarders and Logistics Kenya', 'ocean freight transportation', 'less container load (LCL) and full-container load (FCL) shipments', 'consolidated shipments'
        ]);
        OpenGraph::setDescription('Sea Freight Logistics Kenya, Adamant Logistics offer the best sea freight logistics in Kenya and global sea freights logistics and ocean freights Kenya.');
        OpenGraph::setTitle('Sea Freight');
        OpenGraph::setUrl('https://adamant.co.ke/sea-freight');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Sea Freight Logistics Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/sea-freight');


        return view('pages.sea');
    }

    public function warehouse()
    {
        SEOMeta::setTitle('Warehousing Services Kenya');
        SEOMeta::setDescription('Warehousing services in Kenya for warehousing rentals in Kenya Adamant Logistics solution offers the best warehousing services in Kenya.');
        SEOMeta::addKeyword([
            'the best warehousing services kenya', 'warehouse operations kenya', 'stock control and warehousing',
            'Warehouse jobs in Kenya', 'warehousing service Kenya', 'Warehousing Companies Services in Kenya', 'warehousing with 24 hour surveillance system', 'warehouses with safe storage under required temperatures in Kenya', 'warehousing continuous stock administration in Kenya', 'warehousing labeling of stocks in Kenya', 'warehousing bundling and packaging in Kenya'
        ]);
        OpenGraph::setDescription('Warehousing services in Kenya for warehousing rentals in Kenya Adamant Logistics solution offers the best warehousing services in Kenya.');
        OpenGraph::setTitle('Warehousing Services Kenya');
        OpenGraph::setUrl('https://adamant.co.ke/warehousing-services');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Warehousing Services Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/warehousing-services');


        return view('pages.warehouse');
    }

    public function custom()
    {
        SEOMeta::setTitle('Custom Brokerage in Kenya');
        SEOMeta::setDescription('Kenya custom brokerage in Kenya Adamant Logistics solution offer custom brokerage services such as Customs Clearance & Brokerage in Kenya.');
        SEOMeta::addKeyword([
            'Custom Brokerage Kenya', 'customs practices and requirements in East and Central Africa', 'customs and port clearance',
            'customs brokerage online systems', 'Customs Clearance & Brokerage', 'import and export processes custom clearance', 'Kenya Clearing & Forwarding Agents', 'online brokerage comparison', 'Custom brokers in Kenya', 'Custom brokerage applicable permits and licenses'
        ]);
        OpenGraph::setDescription('Adamant Logistics offer warehousing services, customs clearance, refrigerated trucks services, supply chain consultancy, sea freight and air freight.');
        OpenGraph::setTitle('Custom Brokerage');
        OpenGraph::setUrl('https://adamant.co.ke/custom-brokerage');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Custom Brokerage in Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/custom-brokerage');


        return view('pages.custom');
    }

    public function transport()
    {
        SEOMeta::setTitle('Transport and distribution in Kenya');
        SEOMeta::setDescription('Transport and Logistics distribution in Kenya Adamant Logistics offer the best transport and logistics for better services in transport and distribution.');
        SEOMeta::addKeyword([
            'Adamant Logistics transport and logistics', 'cargo transport logistics within East and Central Africa', 'distribution containerized consignments both – 20ft and 40ft in Kenya',
            'loose cargo transport and logistics', 'pick-ups and mini-trucks for door-to-door deliveries', 'light and heavy Lorries for cargo deliveries', 'Driver & Transport Servicess', 'Logistics and Transport distribution', 'transport trailers are technologically equipped in Kenya', 'cargo escort services Kenya', 'Logistics transport and distribution'
        ]);
        OpenGraph::setDescription('Transport and Logistics distribution in Kenya Adamant Logistics offer the best transport and logistics for better services in transport and distribution.');
        OpenGraph::setTitle('Transport and distribution in Kenya');
        OpenGraph::setUrl('https://adamant.co.ke/transport-and-distribution');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Transport and distribution in Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/transport-and-distribution');


        return view('pages.transport');
    }

    public function trucks()
    {
        SEOMeta::setTitle('Refrigerated trucks Kenya');
        SEOMeta::setDescription('Kenya refrigerated trucks in Kenya Adamant Logistics has the best refrigerated trucks in Kenya to deliver fresh goods in refrigerated trucks in East Africa.');
        SEOMeta::addKeyword([
            'refrigerated frozen transport services in Kenya', 'refrigerated trailers for motor vehicles in Kenya', 'Refrigerated Trucks For Sale',
            'Used Refrigerated Trucks in Kenya', 'refrigerated trucks Kenya', 'refrigerated trucks and Trailers commercial vehicles and heavy equipment', 'refrigerated tucks transportation of meat', 'refrigerated tucks transportation of veggies', 'refrigerated tucks transportation of vegetables', 'refrigerated tucks  transportation of perishable products', 'refrigerated tucks for transport and distribution'
        ]);
        OpenGraph::setDescription('Kenya refrigerated trucks in Kenya Adamant Logistics has the best refrigerated trucks in Kenya to deliver fresh goods in refrigerated trucks in East Africa.');
        OpenGraph::setTitle('Refrigerated trucks in Kenya');
        OpenGraph::setUrl('https://adamant.co.ke/refrigerated-trucks-in-kenya');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Refrigerated trucks Kenya');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/refrigerated-trucks-in-kenya');


        return view('pages.trucks');
    }

    public function relocate()
    {
        SEOMeta::setTitle('Moving and Relocations');
        SEOMeta::setDescription('We move you without the hassle. We know the process of moving can be difficult and we can make the process hassle-free from the beginning to the end.');
        SEOMeta::addKeyword(['Moving and Relocations']);
        OpenGraph::setDescription('We move you without the hassle. We know the process of moving can be difficult and we can make the process hassle-free from the beginning to the end.');
        OpenGraph::setTitle('Moving and Relocations');
        OpenGraph::setUrl('https://adamant.co.ke/moving-and-relocation');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Moving and Relocations');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/moving-and-relocation');


        return view('pages.relocate');
    }

    public function cold()
    {
        SEOMeta::setTitle('Cold Chain Transaction');
        SEOMeta::setDescription('With an extensive fleet of Refrigerated Trucks in Kenya, we can tailor-make the exact cold chain logistics services and solutions your products require for both local and transit shipments.');
        SEOMeta::addKeyword(['Cold Chain Transaction']);
        OpenGraph::setDescription('With an extensive fleet of Refrigerated Trucks in Kenya, we can tailor-make the exact cold chain logistics services and solutions your products require for both local and transit shipments.');
        OpenGraph::setTitle('Cold Chain Transaction');
        OpenGraph::setUrl('https://adamant.co.ke/cold-chain-transportation');
        OpenGraph::addProperty('type', 'website');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-US']);

        TwitterCard::setTitle('Cold Chain Transaction');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/cold-chain-transportation');

        return view('pages.cold');
    }
}
