<!DOCTYPE html>
<html data-theme="black" lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="shortcut icon" type="image/png" href="{{asset('images/logo.png')}}">

    {!! SEO::generate() !!}

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{asset('css/animate.css')}}">
    <link rel="stylesheet" href="{{asset('css/magnific-popup.css')}}">
    <link rel="stylesheet" href="{{asset('css/slick.css')}}">
    <link rel="stylesheet" href="{{asset('css/LineIcons.2.0.css')}}">
    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js" defer></script>
</head>

<body>
    <header class="header-area">
        <div class="navbar-area">
            <div class="w-full fixed z-auto bg-black">
                <div class="container mx-auto flex flex-row justify-between flex-1 flex-shrink-0 space-x-3 text-white">
                    <div class="flex flex-row justify-start space-x-4 items-center align-middle text-center text-sm">
                        <div
                            class="rounded opacity-80 px-2 py-1 flex flex-row items-center align-middle text-center space-x-1 hover:text-orange-500">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="w-6 h-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                            </svg>
                            <a class="hidden md:block" href="mailto:info@adamant.co.ke">info@adamant.co.ke</a>
                        </div>
                        <div
                            class="rounded opacity-80 px-2 py-1 flex flex-row items-center align-middle text-center space-x-1 hover:text-orange-500">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="w-6 h-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" />
                            </svg>
                            <a class="hidden md:block" href="tel:+254711503668">+254 711503668</a>
                        </div>
                        <div
                            class="rounded opacity-80 px-2 py-1 flex flex-row items-center align-middle text-center space-x-1 hover:text-orange-500">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="w-6 h-6">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" />
                            </svg>
                            <a class="hidden md:block" href="tel:+254728991344">+254 728991344</a>
                        </div>
                    </div>
                    <div class="flex flex-row justify-end space-x-4 items-center align-middle text-center pb-1">
                        <a href="https://www.facebook.com/pages/category/Business-Service/Adamant-Logistics-Solutions-Ltd-105929314257431/"
                            target="_blank" rel="noopener noreferrer"
                            class="rounded btn btn-sm btn-ghost btn-square hover:text-orange-500">
                            <svg class="inline-block w-5 h-5 fill-current" xmlns="http://www.w3.org/2000/svg" width="16"
                                height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                                <path
                                    d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951z" />
                            </svg>
                        </a>
                        <a href="https://twitter.com/adamantlogistic"
                            class="rounded btn btn-sm btn-ghost btn-square hover:text-orange-500" target="_blank"
                            rel="noopener noreferrer">
                            <svg class="inline-block w-5 h-5 fill-current" xmlns="http://www.w3.org/2000/svg" width="16"
                                height="16" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                                <path
                                    d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334 0-.14 0-.282-.006-.422A6.685 6.685 0 0 0 16 3.542a6.658 6.658 0 0 1-1.889.518 3.301 3.301 0 0 0 1.447-1.817 6.533 6.533 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.325 9.325 0 0 1-6.767-3.429 3.289 3.289 0 0 0 1.018 4.382A3.323 3.323 0 0 1 .64 6.575v.045a3.288 3.288 0 0 0 2.632 3.218 3.203 3.203 0 0 1-.865.115 3.23 3.23 0 0 1-.614-.057 3.283 3.283 0 0 0 3.067 2.277A6.588 6.588 0 0 1 .78 13.58a6.32 6.32 0 0 1-.78-.045A9.344 9.344 0 0 0 5.026 15z" />
                            </svg>
                        </a>
                        <a href="https://ke.linkedin.com/company/adamant-logistics-solutions?trk=public_profile_topcard_current_company"
                            class="rounded btn btn-sm btn-ghost btn-square hover:text-orange-500" target="_blank"
                            rel="noopener noreferrer">
                            <svg class="inline-block w-5 h-5 fill-current" xmlns="http://www.w3.org/2000/svg" width="16"
                                height="16" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                                <path
                                    d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854V1.146zm4.943 12.248V6.169H2.542v7.225h2.401zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248-.822 0-1.359.54-1.359 1.248 0 .694.521 1.248 1.327 1.248h.016zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016a5.54 5.54 0 0 1 .016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225h2.4z" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div x-data="{ open: false }" class="w-full mx-auto bg-black relative mt-8 z-30 border-t border-gray-200">
                <!-- start -->
                <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="flex justify-between h-28">
                        <div class="flex">
                            <!-- Logo -->
                            <div class="shrink-0 flex items-center">
                                <a class="mr-4 navbar-brand" href="/">
                                    <img class="h-24 rounded" src="{{asset('images/logo.png')}}" alt="Adamant Logo">
                                </a>
                            </div>

                            <!-- Navigation Links -->
                            <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex md:ml-24">
                                <x-nav-link :href="route('home')" :active="request()->routeIs('home')">
                                    Home
                                </x-nav-link>
                                <x-nav-link :href="route('about')" :active="request()->routeIs('about')">
                                    About&nbsp;Us
                                </x-nav-link>
                                <x-dropdown align="right" width="60">
                                    <x-slot name="trigger">
                                        <x-nav-link>
                                            <span class="inline-flex mt-11 hover:text-orange-500">
                                                Services
                                                <svg class="ml-2 -mr-0.5 mt-1 h-4 w-4"
                                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                    fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            </span>
                                        </x-nav-link>
                                    </x-slot>

                                    <x-slot name="content">
                                        <div class="w-52">
                                            <x-dropdown-link href="{{ route('air')}}">
                                                <span>Air Freight</span>
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('sea')}}">
                                                Sea Freight
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('custom')}}">
                                                Customs Brokerage
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('cold')}}">
                                                Cold Chain Transport
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('warehouse')}}">
                                                Warehousing
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('transport')}}">
                                                Transport and Distribution
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('relocate')}}">
                                                Moving and Relocation
                                            </x-dropdown-link>
                                            <x-dropdown-link href="{{ route('supply')}}">
                                                Supply chain consultancy
                                            </x-dropdown-link>
                                        </div>
                                    </x-slot>
                                </x-dropdown>
                                <x-nav-link :href="route('quote')" :active="request()->routeIs('quote')">
                                    Get&nbsp;a&nbsp;Quote
                                </x-nav-link>
                                <x-nav-link :href="route('contact')" :active="request()->routeIs('contact')">
                                    Contact&nbsp;Us
                                </x-nav-link>
                            </div>
                        </div>

                        <!-- Hamburger -->
                        <div class="-mr-2 flex items-center sm:hidden">
                            <button @click="open = ! open"
                                class="inline-flex items-center justify-center p-2 rounded-md text-white hover:text-gray-900 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out">
                                <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                    <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M4 6h16M4 12h16M4 18h16" />
                                    <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden"
                                        stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Responsive Navigation Menu -->
                <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
                    <div class="pt-2 pb-3 space-y-1">
                        <x-responsive-nav-link :href="route('home')" :active="request()->routeIs('home')">
                            Home
                        </x-responsive-nav-link>
                        <x-responsive-nav-link :href="route('about')" :active="request()->routeIs('about')">
                            About&nbsp;Us
                        </x-responsive-nav-link>
                        <x-dropdown align="right" width="60">
                            <x-slot name="trigger">
                                <x-responsive-nav-link>
                                    <span class="inline-flex hover:text-orange-500">
                                        Services
                                        <svg class="ml-2 -mr-0.5 mt-1 h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                            viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </span>
                                </x-responsive-nav-link>
                            </x-slot>
                            <x-slot name="content">
                                <div class="w-52">
                                    <x-dropdown-link href="{{ route('air')}}">
                                        <span>Air Freight</span>
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('sea')}}">
                                        Sea Freight
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('custom')}}">
                                        Customs Brokerage
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('cold')}}">
                                        Cold Chain Transport
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('warehouse')}}">
                                        Warehousing
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('transport')}}">
                                        Transport and Distribution
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('relocate')}}">
                                        Moving and Relocation
                                    </x-dropdown-link>
                                    <x-dropdown-link href="{{ route('supply')}}">
                                        Supply chain consultancy
                                    </x-dropdown-link>
                                </div>
                            </x-slot>
                        </x-dropdown>
                        <x-responsive-nav-link :href="route('quote')" :active="request()->routeIs('quote')">
                            Get&nbsp;a&nbsp;Quote
                        </x-responsive-nav-link>
                        <x-responsive-nav-link :href="route('contact')" :active="request()->routeIs('contact')">
                            Contact&nbsp;Us
                        </x-responsive-nav-link>
                    </div>
                </div>
                {{-- end --}}

            </div> <!-- container -->
        </div> <!-- navbar area -->
    </header>
    <main>
        {{ $slot }}
    </main>
    <footer class="relative footer-area pt-120">
        <div class="footer-bg bg-black"></div>
        <div class="container mx-auto px-3">
            <div class="footer-widget pb-120">
                <div class="row">
                    <div class="w-full md:w-3/5 lg:w-2/6">
                        <div class="mt-12 footer-about wow fadeIn" data-wow-duration="1s" data-wow-delay="0.2s">
                            <a class="inline-block mb-8 logo" href="index.html">
                                <img src="{{asset('images/logo.png')}}" alt="Adamant Logistics logo"
                                    class="h-20 rounded">
                            </a>
                            <p class="pb-10 pr-10 leading-snug text-white">Adamant Logistics is an integrated end to end
                                logistics service provider. We plan, implement and operate complex supply
                                chain solutions on a national, regional and global scale on behalf of medium to
                                large corporate firms.</p>
                            <ul class="flex footer-social">
                                <li><a
                                        href="https://www.facebook.com/pages/category/Business-Service/Adamant-Logistics-Solutions-Ltd-105929314257431/"><i
                                            class="lni lni-facebook-filled"></i></a></li>
                                <li><a href="https://twitter.com/adamantlogistic"><i
                                            class="lni lni-twitter-filled"></i></a></li>
                                <li><a
                                        href="https://ke.linkedin.com/company/adamant-logistics-solutions?trk=public_profile_topcard_current_company"><i
                                            class="lni lni-linkedin-original"></i></a></li>
                            </ul>
                        </div> <!-- footer about -->
                    </div>
                    <div class="w-4/5 sm:w-2/3 md:w-3/5 lg:w-2/6">
                        <div class="row">
                            <div class="w-full sm:w-1/2 md:w-1/2 lg:w-1/2">
                                <div class="mt-12 link-wrapper wow fadeIn" data-wow-duration="1s" data-wow-delay="0.4s">
                                    <div class="footer-title">
                                        <h4 class="mb-8 text-2xl font-bold text-white">Our Services</h4>
                                    </div>
                                    <ul class="link">
                                        <li><a href="{{route('air')}}">Air Freight</a></li>
                                        <li><a href="{{route('sea')}}">Sea Freight</a></li>
                                        <li><a href="{{route('custom')}}">Customs Brokerage</a></li>
                                        <li><a href="{{route('cold')}}">Cold Chain Transport</a></li>
                                        <li><a href="{{route('warehouse')}}">Warehousing</a></li>
                                        <li><a href="{{route('transport')}}">Transport and Distribution</a></li>
                                        <li><a href="{{route('relocate')}}">Moving and Relocation</a></li>
                                        <li><a href="{{route('supply')}}">Supply Chain consultancy</a></li>
                                    </ul>
                                </div> <!-- footer wrapper -->
                            </div>
                            <div class="w-full sm:w-1/2 md:w-1/2 lg:w-1/2">
                                <div class="mt-12 link-wrapper wow fadeIn" data-wow-duration="1s" data-wow-delay="0.6s">
                                    <div class="footer-title">
                                        <h4 class="mb-8 text-2xl font-bold text-white">Company</h4>
                                    </div>
                                    <ul class="link">
                                        <li><a href="{{route('about')}}">About Us</a></li>
                                        <li><a href="{{route('quote')}}">Get a Quote</a></li>
                                        <li><a href="{{route('contact')}}">Contact Us</a></li>
                                        {{-- <li><a href="{{route('terms')}}">Terms of Service</a></li> --}}
                                    </ul>
                                </div> <!-- footer wrapper -->
                            </div>
                        </div>
                    </div>
                    <div class="w-4/5 sm:w-1/3 md:w-2/5 lg:w-2/6">
                        <div class="mt-12 footer-contact wow fadeIn" data-wow-duration="1s" data-wow-delay="0.8s">
                            <div class="footer-title">
                                <h4 class="mb-8 text-2xl font-bold text-white">Contact Us</h4>
                            </div>
                            <ul class="contact">
                                <li>
                                    <a href="tel:+254711503668" class="flex flex-row space-x-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" />
                                        </svg>
                                        <span>+254 711503668</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="tel:+254728991344" class="flex flex-row space-x-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" />
                                        </svg>
                                        <span>+254 728991344</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="mailto:info@adamant.co.ke" class="flex flex-row space-x-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                                        </svg>
                                        <span>info@adamant.co.ke</span>
                                    </a>
                                </li>
                                <li>2nd Floor, Pili Trade Center, along Mombasa Road, Nairobi, Kenya.</li>
                            </ul>
                        </div> <!-- footer contact -->
                    </div>
                </div> <!-- row -->
            </div> <!-- footer widget -->
            <div class="py-8 border-t border-gray-200 footer-copyright">
                <p class="text-white">&copy;
                    <?php echo date("Y");?> All Rights Reserved by
                    <a class="duration-300 hover:text-theme-color-2" href="{{ url('/') }}">{{ config('app.name',
                        'Adamant Logistics')
                        }}</a>
                </p>
            </div> <!-- footer copyright -->
        </div> <!-- container -->
        <div id="particles-2" class="particles"></div>
    </footer>
    <a href="#" class="back-to-top"><i class="lni lni-chevron-up"></i></a>
</body>

</html>
