<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ServiceController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__ . '/auth.php';

Route::get('shop-and-ship', [HomeController::class, 'shopship'])->name('shopship');
Route::get('services', [HomeController::class, 'services'])->name('services');
Route::get('get-a-quote', [HomeController::class, 'quote'])->name('quote');
Route::get('contact', [HomeController::class, 'contact'])->name('contact');
Route::get('about', [HomeController::class, 'about'])->name('about');
Route::get('terms', [HomeController::class, 'terms'])->name('terms');

// services
Route::get('supply-chain-consultancy', [ServiceController::class, 'supply'])->name('supply');
Route::get('air-freight', [ServiceController::class, 'air'])->name('air');
Route::get('sea-freight', [ServiceController::class, 'sea'])->name('sea');
Route::get('warehousing-services', [ServiceController::class, 'warehouse'])->name('warehouse');
Route::get('custom-brokerage', [ServiceController::class, 'custom'])->name('custom');
Route::get('transport-and-distribution', [ServiceController::class, 'transport'])->name('transport');
Route::get('cold-chain-transportation', [ServiceController::class, 'cold'])->name('cold');
Route::get('refrigerated-trucks-in-kenya', [ServiceController::class, 'trucks'])->name('trucks');
Route::get('moving-and-relocation', [ServiceController::class, 'relocate'])->name('relocate');

// Contact form
Route::post('contact/form', [HomeController::class, 'contactForm'])->name('contact.form');

// Get a quote
Route::post('quote/form', [HomeController::class, 'quoteForm'])->name('quote.form');
