const mix = require('laravel-mix');
const NodePolyfillPlugin = require('node-polyfill-webpack-plugin');

mix.webpackConfig({
    plugins: [
        new NodePolyfillPlugin(),
    ],
    resolve: {
        fallback: {
            fs: require.resolve('browserify-fs'),
        }
    }
});

mix.js('resources/js/app.js', 'public/js').postCss('resources/css/app.css', 'public/css', [
    require('postcss-import'),
    require('tailwindcss'),
    require('autoprefixer'),
])
    .copy('node_modules/wowjs/css/libs/animate.css', 'public/css')
    .copy('node_modules/scrollnav/dist/scrollnav.min.js', 'public/js')
    .copy('node_modules/magnific-popup/dist/magnific-popup.css', 'public/css')
    .copy('node_modules/slick-carousel/slick/slick.css', 'public/css');
